/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.lifecycle.mixin;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.quiltmc.qsl.lifecycle.api.event.ServerLifecycleEvents;
import org.quiltmc.qsl.lifecycle.api.event.ServerTickEvents;
import org.quiltmc.qsl.lifecycle.api.event.ServerWorldLoadEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin {
    MinecraftServerMixin() {
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setupServer()Z")})
    private void serverStarting(CallbackInfo info) {
        ((ServerLifecycleEvents.Starting)ServerLifecycleEvents.STARTING.invoker()).startingServer((MinecraftServer)this);
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setFavicon(Lnet/minecraft/server/ServerMetadata;)V", ordinal=0)})
    private void serverReady(CallbackInfo info) {
        ((ServerLifecycleEvents.Ready)ServerLifecycleEvents.READY.invoker()).readyServer((MinecraftServer)this);
    }

    @Inject(method={"shutdown"}, at={@At(value="HEAD")})
    private void serverStopping(CallbackInfo info) {
        ((ServerLifecycleEvents.Stopping)ServerLifecycleEvents.STOPPING.invoker()).stoppingServer((MinecraftServer)this);
    }

    @Inject(method={"shutdown"}, at={@At(value="TAIL")})
    private void serverExit(CallbackInfo info) {
        ((ServerLifecycleEvents.Stopped)ServerLifecycleEvents.STOPPED.invoker()).exitServer((MinecraftServer)this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickWorlds(Ljava/util/function/BooleanSupplier;)V")})
    private void startServerTick(CallbackInfo info) {
        ((ServerTickEvents.Start)ServerTickEvents.START.invoker()).startServerTick((MinecraftServer)this);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void endServerTick(CallbackInfo info) {
        ((ServerTickEvents.End)ServerTickEvents.END.invoker()).endServerTick((MinecraftServer)this);
    }

    @Redirect(method={"createWorlds"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private <K, V> V loadWorld(Map<K, V> worlds, K key, V world) {
        V result = worlds.put(key, world);
        ((ServerWorldLoadEvents.Load)ServerWorldLoadEvents.LOAD.invoker()).loadWorld((MinecraftServer)this, (class_3218)world);
        return result;
    }

    @Inject(method={"shutdown"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;close()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void unloadWorld(CallbackInfo info, Iterator<class_3218> iterator, class_3218 world) {
        ((ServerWorldLoadEvents.Unload)ServerWorldLoadEvents.UNLOAD.invoker()).unloadWorld((MinecraftServer)this, world);
    }
}

